	function [Pap, Wpas] = EQ_TG_LP_Z(W1T, W2T, G, Z, P, Nap)

	% 	Determine poles for an allpass filter that corrects the group delay
	% 	for a digital lowpass filter in approximately equiripple sence.

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-09-28
	% 	Modified by: 		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	global FX LDT Dmin NF NL V Q0 Q1 QA QB QC QD0 QD1 QF1 Tol Tol1 H X
	global p TgH Wpas points
	points = 100*Nap; n = [0:points];
	% Select a denser grid close to the band edge
	Wpas = W1T + (W2T-W1T)*sin(n*pi/(2*points));	% LP
	%	Wpas = W2 - (W2-W1)*cos(n*pi/(2*points));	% HP
	%	Wpas = (W2+W1)/2 - (W2-W1)*cos(n*pi/(2*points))/2;	% BP	
	TgH = PZ_2_TG_Z(G, Z, P, Wpas);
	m = 1;
	for n = -Nap+mod(Nap,2):2:Nap-mod(Nap,2)	% Select initial poles of the allpass sections
		Pap(m) = 0.95*(cos(n*W2T/2/Nap) + i*sin(n*W2T/2/Nap));
		m = m+1;
	end
	Pap = cplxpair(Pap);
	if mod(Nap,2) == 0 & (n ~= 0)	
		Pap(Nap+1) = [];
	end
	%	Convert poles to real parameters 	
	X = EQ_P_PARAM_Z(Pap, Nap);

	h = 0.1;	Tol = 10^-13;	Print = 0;	Fmin = 0; SCBD = 2; KTM = 1;
	ILLC = (1==0);		% illc = false;	
	for p = 2:2:10	
		[X, Cost] = PRAXIS('EQ_AP_LP_Z', Nap, h, Print, ILLC, SCBD, KTM, Fmin);	
	end
	Pap = EQ_PARAM_P_Z(X, Nap);
	Taug = PZ_2_TG_Z(1, 1./Pap, Pap, Wpas);
	Minimax_ERROR = 0.5*(max(Taug+TgH)-min(Taug+TgH))
	return
